from django.shortcuts import render
from deep_translator import GoogleTranslator

def translatecorner(request):
    result = ''
    if request.method == 'POST':
        text = request.POST.get('text', '')
        language = request.POST.get('language', 'en')
        if not text:
            result = ''
        else:
            try:
                translator = GoogleTranslator(source='auto', target=language)
                result = translator.translate(text)
            except Exception as e:
                error_msg = str(e)
                if '429' in error_msg or 'rate limit' in error_msg.lower():
                    result = 'error: you reached your limit.try later.'
                elif 'HTTPError' in error_msg:
                    result = 'error: try lates.'
                else:
                    result = f'error: {error_msg}'

    return render(request, 'translator.html', {'result': result})